/************************************************************************************************************\

Module Name:    LTimer.h

Description:    Write description here.

References:     None.

    Copyright (c) 2009, Matrox Graphics Inc.
    All Rights Reserved.

\************************************************************************************************************/

#ifndef INC_LTIMER_H
#define INC_LTIMER_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                                   U S A G E
// -----------------------------------------------------------------------------------------------------------

#if defined (__cplusplus)
extern "C" {
#endif

/************************************************************************************************************\

Function:       LTimer_Create

Description:    Create timer oject.

Parameters:     hDev    Handle to device object.

Return Value:   TIME_HANDLE.

Comments:       None.

\************************************************************************************************************/
LAPI LStatus LTimer_Create(LTimer_Handle* phTimer);

/************************************************************************************************************\

Function:       LTimer_Destroy

Description:    Destroy timer object.

Parameters:     hTimer   Timer object

Return Value:   None.

Comments:       hTimer cannot be use after we release ressources.

\************************************************************************************************************/
LAPI LStatus LTimer_Destroy(LTimer_Handle hTimer);


/************************************************************************************************************\

Function:       LTimer_Reset

Description:    clear total and delta counter.

Parameters:     hTimer   

Return Value:   None.

Comments:       next call to LTimer_delta or LTimer_total will return number of us count after this call.

\************************************************************************************************************/
LAPI LStatus LTimer_Reset(LTimer_Handle hTimer);

/************************************************************************************************************\

Function:       LTimer_GetElapsedTime

Description:    return delta counter value and  clear it.

Parameters:     hTimer   

Return Value:   us from last delta.

Comments:       None.

\************************************************************************************************************/
MUINT32 LTimer_GetElapsedTime(LTimer_Handle hTimer);

/************************************************************************************************************\

Function:       LTimer_GetTotalTime

Description:    return count from last reset.

Parameters:     hTimer   

Return Value:   count from last reset.

Comments:       None.

\************************************************************************************************************/
MUINT32 LTimer_GetTotalTime(LTimer_Handle hTimer);



#if defined (__cplusplus)
}
#endif

#endif // INC_LTIMER_H
